#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//StarFieldAlephMod01.fsh   by  AriesTiger 
//https://www.shadertoy.com/view/fscGzX
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//takes input angle rotation func, returns a rotation matrix

#define NUM_LAYERS 9.
mat2 Rotate(float a)

{
    float s=sin(a), c=cos(a);
    return mat2(c, -s, s, c);
}

float Star(vec2 uv, float flare)
{
     
    //gets length to center of screen
    float d = length(uv);
    float m = .05/d;
    
    //lense flare
    float rays = max(0., .5-abs(uv.x*uv.y*1200.0));
    m += rays*flare;
    
    //second lense flare
    uv *= Rotate(3.14159265/4.);
    rays = max(0., 1./.5-abs(uv.x*uv.y*2000.0));
    m += rays*.3*flare;
    m*= smoothstep(.4, .2, d);
    return m;
     
}
//RNG
float Hash21(vec2 p)
{
    p = fract(p*vec2(123.34, 456.21));
    p += dot(p, p+45.32);
    return fract(p.x*p.y);
}

vec3 StarLayer(vec2 uv)
{
    vec3 col = vec3(0);
 //making boxes
    vec2 gv = fract(uv)-.5;
   vec2 id = floor(uv);
   
   //iter thru 3x3 nbhd to add local contributions of light
   for(int y=-1; y<=1; y++)
    {
        for(int x = -1; x<=1; x++)
        {
        //offset
        vec2 offs = vec2(x, y);
        float r = Hash21(id + offs); //rand btwn 0 & 1
        float luminosity = fract(r*3817345.32);
        float star = Star(gv-offs-vec2(r-.5,fract(r*72.)), smoothstep(.6, .8, luminosity));
        col += star*luminosity;
        
        float colNum = 8682.90;
        vec3 color = sin(vec3(.2, .3, .9)*fract(r*546.657)*colNum)*.7+.5;
        //specifying colors
        color = color*vec3(1.+.5, 0., 1.+.5);
        star *= sin(iTime*3.+r*6.3)*.5+1.;
        col+=star*luminosity*color;

        }
    }
            return col;
    
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
    float t = iTime*.05;
    uv*=8.;
    uv*= Rotate(t);
    vec3 col = vec3(0);
    
    for(float i=0.; i<1.; i+=1./NUM_LAYERS)
    {
        float depth = fract(i+t);
        
        float scale = mix(7., .5, depth);
        float fade = depth*smoothstep(1., .9, depth);
        col+=StarLayer(uv*scale+i*42.)*fade;
    fragColor = vec4(col,1.0);
}


/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

